#!/bin/bash
fixed_yamls=(
#  "Amazon_cloth_sport.yaml"
#  "Amazon_sport_cloth.yaml"
#  "Amazon_cloth_video.yaml"
#  "Amazon_video_cloth.yaml"
  "Douban_Movie_Music.yaml"
  "Douban_Music_Movie.yaml"

)
flexible_experiments=(
#   "dtcdr.test"
#   "unicdr_best_ori.test"
#   "bitgcf_best_ori.test"
#   "bitgcf_best_gen_del.test"
#  "bitgcf_best_del.test"
#  "bpr_gnn.test"
#  "cut_tuning_best_ori_1layer.test"
#  "cut_tuning_del.test"
#  "cut_tuning_gen.test"
   "lightgcn_gen_del.test"
   "cut_tuning_gen_del.test"
#  "lightgcn_best_ori.test"
#  "lightgcn_del.test"
#  "lightgcn_gen.test"
#   "lightgcn_dgl_best_ori.test"
#  "ccdr_best_ori.test"
#  "ccdr_best_del.test"
#  "ccdr_best_gen_del.test"
)
output_dir="www2026_experiments"
mkdir -p "${output_dir}"
for fixed_yaml in "${fixed_yamls[@]}"; do
  for experiment in "${flexible_experiments[@]}"; do
    yaml_name="${fixed_yaml%.yaml}"
    model_name="${experiment%*}"
    output_file="${output_dir}/${model_name}_${yaml_name}_new"
    # 运行命令
    echo "Running: python run_hyper.py --yaml hyper_fixed/${fixed_yaml} --yaml_hyper_test hyper_flexible/${experiment} --output_file ${output_file}"
    python run_hyper.py --yaml "hyper_fixed/${fixed_yaml}" --yaml_hyper_test "hyper_flexible/${experiment}" --output_file "${output_file}"
  done
done